﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using MFORMATSLib;

namespace SampleLiveMixing
{
    public partial class Form1 : Form
    {
        private MFPreviewClass m_objPreview;
        private MFLiveClass m_objLive;
        private MFReaderClass m_objReader;
        private MDelayClass m_objDelay;
        private MFSinkClass m_objMFSink;
        System.Windows.Forms.Timer delayTimer;
        private Thread m_threadWorker;	//Working thread
        private Thread m_NDIcheckThread;
        private bool m_bWork;

        private object m_objLock;

        private double m_dblAlpha = 0.5;

        private M_AV_PROPS m_avProps;

        public Form1()
        {
            InitializeComponent();
        }

        private CancellationTokenSource cancelSource;
        private void Form1_Load(object sender, EventArgs e)
        {
            delayTimer = new System.Windows.Forms.Timer();
            delayTimer.Interval = 1000;
            delayTimer.Tick += DelayTimer_Tick;
            delayTimer.Start();
            m_objPreview = new MFPreviewClass();
            m_objReader = new MFReaderClass();
            m_objMFSink = new MFSinkClass();
            try
            {
                m_objLive = new MFLiveClass();
            }
            catch (Exception ex)
            {
                MessageBox.Show("MLive device not found\n\n" + ex.ToString());
            }

            m_objDelay = new MDelayClass();
            // set video codec
            m_objDelay.PropsSet("mdelay.video_codec", "libopenh264");
            // and its attributes like bitrate and gop size
            m_objDelay.PropsSet("mdelay.video_props", "b='5M' g='12'");
            m_objLock = new object();
            //Configure preview
            m_objPreview.PreviewWindowSet("", panelPreview.Handle.ToInt32());
            m_objPreview.PreviewEnable("", Convert.ToInt32(checkBoxAPrev.Checked), Convert.ToInt32(checkBoxVPrev.Checked));

            FillVideoFormats();

            //Fill live devices
            FillMLiveDevices();

            //Configure MDelay feature

            //textBoxTimeDelay.Text = trackBarTimeDelay.Value.ToString();

            //  m_objDelay.PropsSet("object::mdelay.enabled", checkBoxDelay.Checked ? "true" : "false");
            //  m_objDelay.PropsSet("object::mdelay.time", textBoxTimeDelay.Text);


            // Create & config background worker
            cancelSource = new CancellationTokenSource();
            m_threadWorker = new Thread(() => thread_DoWork(cancelSource.Token));
            m_threadWorker.Name = "thread_DoWork";
            m_threadWorker.Start();

            System.Windows.Forms.Control.CheckForIllegalCrossThreadCalls = false;   //Need for use renderersCombobox in multithreading 
        }

        private void DelayTimer_Tick(object sender, EventArgs e)
        {
            if (m_objDelay!=null)
            {
                M_DATETIME startTimeMoment;
                double bufferStart;
                double bufferEnd;
                try
                {
                    m_objDelay.DelayAvailable(out startTimeMoment, out bufferStart, out bufferEnd);
                    trackBarTimeDelay.Maximum = (int)(Math.Round(bufferEnd - bufferStart)/10000000);
                    delayTime.Maximum = trackBarTimeDelay.Maximum;
                    labelAvailable.Text = trackBarTimeDelay.Maximum + " s";
                }
                catch
                {

                }
            }
        }

        private void FillVideoFormats()
        {
            comboBoxVideoFormat.Items.Clear();

            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_Custom);

            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_NTSC);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_NTSC_2398);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_NTSC_16x9);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_PAL);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_PAL_16x9);

            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD720_50p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD720_5994p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD720_60p);

            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD1080_2398p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD1080_24p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD1080_25p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD1080_2997p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD1080_30p);

            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD1080_50i);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD1080_5994i);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD1080_60i);

            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD1080_50p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD1080_5994p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_HD1080_60p);

            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_2K_DCI_2398p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_2K_DCI_24p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_2K_DCI_25p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_2K_DCI_50p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_2K_DCI_5994p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_2K_DCI_60p);

            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_2K_2398p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_2K_24p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_2K_25p);

            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_4K_DCI_2398p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_4K_DCI_24p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_4K_DCI_25p);

            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_4K_UHD_50i);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_4K_UHD_5994i);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_4K_UHD_60i);

            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_4K_UHD_50p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_4K_UHD_5994p);
            comboBoxVideoFormat.Items.Add(eMVideoFormat.eMVF_4K_UHD_60p);
            comboBoxVideoFormat.SelectedIndex = 0;

            m_avProps = new M_AV_PROPS();
            m_avProps.vidProps.eVideoFormat = (eMVideoFormat)comboBoxVideoFormat.SelectedItem;
        }

        private void thread_DoWork(CancellationToken token)
        {
            while (!token.IsCancellationRequested)
            {
                if (m_bWork)
                {

                    MFFrame pFrame = null;
                    lock (m_objLock)
                    {
                        try
                        {
                            m_objLive.SourceFrameConvertedGet(ref m_avProps, -1, out pFrame, "");
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show(ex.ToString());
                            m_bWork = false;
                        }
                    }

                    if (pFrame != null)
                    {
                        if (checkBoxDelay.Checked)
                        {
                            int nFramesRes;
                            MFFrame pFrameOut = null;

                            m_objDelay.ProcessFrame(pFrame, out pFrameOut, out nFramesRes, "");

                            if (pFrameOut != null)
                            {
                                if (pFrame != null) Marshal.ReleaseComObject(pFrame);
                                pFrame = pFrameOut;
                            }
                        }

                        //Overlay frame
                        MFFrame outFrame;
                        FrameOverlay(pFrame, out outFrame);
                        if (outFrame != null)
                        {
                            Marshal.ReleaseComObject(pFrame);
                            pFrame = outFrame;
                        }

                        //Send frame to the preview
                        m_objPreview.ReceiverFramePut(pFrame, -1, "");

                        //Send to Sink
                        SendToSink(pFrame);

                        //Release frame - DO NOT FORGOT TO DO THIS !!!
                        Marshal.ReleaseComObject(pFrame);
                    }
                }
                else
                {
                    Thread.Sleep(1);
                }
            }
        }

        private void SendToSink(MFFrame pFrame)
        {
            if (checkBoxVirtDev.Checked)
            {
                if (m_objMFSink != null)
                {
                    lock (this)
                    {
                        // Send pFrame to Sink
                        try
                        {
                            m_objMFSink.ReceiverFramePut(pFrame, -1, "");
                        }
                        catch
                        { }
                    }
                }
            }
        }

        private void FrameOverlay(MFFrame pFrame, out MFFrame outFrame)
        {
            outFrame = null;
            if (checkBox1.Checked && textBoxFilePath.Text != "")
            {
                M_AV_PROPS avPropsSrc;
                int lAudioSamples = 0;
                pFrame.MFAVPropsGet(out avPropsSrc, out lAudioSamples);

                // For ONLY rate conversion to source video standard
                M_AV_PROPS avPropsPIP = new M_AV_PROPS();
                avPropsPIP.vidProps.dblRate = avPropsSrc.vidProps.dblRate;

                MFFrame pFrame2scaled, pFrame2;
                m_objReader.SourceFrameConvertedGetByTime(ref avPropsPIP, -1, -1, out pFrame2, "");
                pFrame2.MFResize(eMFCC.eMFCC_Default, avPropsSrc.vidProps.nWidth / 4, avPropsSrc.vidProps.nHeight / 4, -1, out pFrame2scaled, "", "ch2");

                // Clone frame for avoid frame flickering (e.g. in format convert)
                pFrame.MFClone(out outFrame, eMFrameClone.eMFC_Full, eMFCC.eMFCC_Default);

                // TODO: MFOverlay docs
                // audio_gain - 0.0 -> No changes (if not present -> audio calc based on size & alpha)
                // symmetric_gain -> (true)
                outFrame.MFOverlay(pFrame2scaled, null, avPropsSrc.vidProps.nWidth / 12, avPropsSrc.vidProps.nHeight / 12, m_dblAlpha, "audio_gain=0.0 symmetric_gain=false", "ch2");
                
                Marshal.ReleaseComObject(pFrame2);
                Marshal.ReleaseComObject(pFrame2scaled);
            }
        }

        private void FillMLiveDevices()
        {
            comboBoxVideo.Items.Clear();
            //Fill video devices
            int vCount;
            m_objLive.DeviceGetCount(eMFDeviceType.eMFDT_Video, out vCount);

            if (vCount > 0)
            {
                for (int i = 0; i < vCount; i++)
                {
                    string strName;
                    int _pbBusy;
                    m_objLive.DeviceGetByIndex(eMFDeviceType.eMFDT_Video, i, out strName, out _pbBusy);
                    comboBoxVideo.Items.Add(strName);

                }
                comboBoxVideo.SelectedIndex = 0;

                buttonInit.Enabled = true;
                buttonClose.Enabled = true;
                FillCombo(eMFDeviceType.eMFDT_ExtAudio, comboBoxAudioEx);
                FillCombo(eMFDeviceType.eMFDT_Audio, comboBoxAudio);
            }
        }


        private void FillCombo(eMFDeviceType strType, ComboBox cbxType)
        {
            cbxType.Items.Clear();
            int nCount = 0;
            //Get device count / input line count
            m_objLive.DeviceGetCount(strType, out nCount);
            cbxType.Enabled = nCount > 0;
            if (nCount > 0)
            {
                for (int i = 0; i < nCount; i++)
                {
                    string strName;
                    int pbBusy;
                    //Get deveice / input line
                    m_objLive.DeviceGetByIndex(strType, i, out strName, out pbBusy);
                    cbxType.Items.Add(strName);
                }
                string name = "";
                int nIndex = 0;
                try
                {
                    //Check if there is already selected device / input line
                    m_objLive.DeviceGet(strType, out nIndex, out name);
                    cbxType.SelectedIndex = nIndex >= 0 && nIndex < cbxType.Items.Count - 1 ? nIndex : 0;
                }
                catch
                {
                    if (strType == eMFDeviceType.eMFDT_Audio)
                    {
                        cbxType.SelectedIndex = cbxType.Items.Count > 1 ? cbxType.Items.Count - 2 : 0;
                    }
                    else
                    {
                        cbxType.SelectedIndex = 0;
                    }
                }
            }
        }


        private void comboBoxV_SelectedIndexChanged(object sender, EventArgs e)
        {
            comboBoxFormat.Items.Clear();
            comboBoxVideoLine.Items.Clear();

            M_VID_PROPS vidProps;

            try
            {
                lock (m_objLock)
                {
                    m_objLive.DeviceSet(eMFDeviceType.eMFDT_Video, comboBoxVideo.SelectedIndex, "");
                }

                int fCount;
                string name;

                m_objLive.FormatVideoGetCount(eMFormatType.eMFT_Input, out fCount);
                if (fCount > 0)
                {
                    for (int i = 0; i < fCount; i++)
                    {
                        m_objLive.FormatVideoGetByIndex(eMFormatType.eMFT_Input, i, out vidProps, out name);
                        comboBoxFormat.Items.Add(name);
                    }

                    // Get current format
                    int nCurrent = 0;
                    try
                    {
                        string strName;
                        M_VID_PROPS _vidProps;
                        m_objLive.FormatVideoGet(eMFormatType.eMFT_Input, out _vidProps, out nCurrent, out strName);
                    }
                    catch (System.Exception)
                    {
                    }

                    // Select current
                    comboBoxFormat.SelectedIndex = nCurrent > 0 ? nCurrent : 0;
                }

                CheckLineIn();

                FillCombo(eMFDeviceType.eMFDT_Audio, comboBoxAudio);
                FillCombo(eMFDeviceType.eMFDT_ExtAudio, comboBoxAudioEx);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }
        }

        void CheckLineIn()
        {
            comboBoxVideoLine.Items.Clear();

            string strCurrent;
            string _pOptions;
            string _pHelp;
            int nSel = -1;
            int lCount;
            m_objLive.PropsGet("line-in", out strCurrent);

            m_objLive.PropsOptionGetCount("line-in", out lCount);
            if (lCount > 0)
            {
                for (int i = 0; i < lCount; i++)
                {
                    m_objLive.PropsOptionGetByIndex("line-in", i, out _pOptions, out _pHelp);
                    comboBoxVideoLine.Items.Add(_pHelp);

                    if (strCurrent == _pOptions)
                        nSel = i;
                }

                if (nSel >= 0)
                    comboBoxVideoLine.SelectedIndex = nSel;
                else
                    comboBoxVideoLine.SelectedIndex = 0;
            }
        }

        private void comboBoxVL_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_objLive.PropsOptionSetByIndex("line-in", comboBoxVideoLine.SelectedIndex);
        }

        private void comboBoxVF_SelectedIndexChanged(object sender, EventArgs e)
        {
            M_VID_PROPS vidProps;
            string name;
            m_objLive.FormatVideoGetByIndex(eMFormatType.eMFT_Input, comboBoxFormat.SelectedIndex, out vidProps, out name);

            lock (m_objLock)
            {
                m_objLive.FormatVideoSet(eMFormatType.eMFT_Input, vidProps);
            }
        }

        private void btnInit_Click(object sender, EventArgs e)
        {
            try
            {
                lock (m_objLock)
                {
                    m_objLive.DeviceSet(eMFDeviceType.eMFDT_Video, comboBoxVideo.SelectedIndex, "");
                    m_objLive.DeviceSet(eMFDeviceType.eMFDT_Audio, comboBoxAudio.SelectedIndex, "");

                    if (comboBoxFormat.SelectedIndex >= 0)
                    {
                        M_VID_PROPS vidProps;
                        string name;
                        m_objLive.FormatVideoGetByIndex(eMFormatType.eMFT_Input, comboBoxFormat.SelectedIndex,
                            out vidProps,
                            out name);
                        m_objLive.FormatVideoSet(eMFormatType.eMFT_Input, vidProps);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Could not start a device.\n\n" + ex);
            }

            // Start worker if not started yet
            if (!m_bWork)
                m_bWork = true;

            GC.Collect();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            m_bWork = false;
            lock (m_objLock)
            {
                m_objLive.DeviceClose();
            }
        }

        private void comboVF_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_avProps.vidProps.eVideoFormat = (eMVideoFormat)comboBoxVideoFormat.SelectedItem;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "Video files |*.wmv; *.avi; *.dv; *.flv; *.gxf; *.m2t; *.m2ts; *.m4v; " +
                          " *.mkv; *.mov; *.mp2; *.mp4; *.mpeg; *.mpeg1; *.mpeg2; *.mpeg4; *.mpg; *.mts; *.m2ts; *.ogg; *.mxf; *.ogv; *.ogx; *.ts; *.vob;";


            if (ofd.ShowDialog() == DialogResult.OK && ofd.FileName.Length > 0)
            {
                textBoxFilePath.Text = ofd.FileName;
                try
                {
                    m_objReader.ReaderOpen(textBoxFilePath.Text, "");
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString());
                    textBoxFilePath.Text = "";
                }
            }
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (textBoxFilePath.Text == "")
                checkBox1.Checked = false;
        }

        private void panelPreview_SizeChanged(object sender, EventArgs e)
        {
            if (m_objPreview != null)
                m_objPreview.PreviewWindowSet("", panelPreview.Handle.ToInt32());
        }

        private void checkBoxAPrev_CheckedChanged(object sender, EventArgs e)
        {
            if (m_objPreview != null)
                m_objPreview.PreviewEnable("", Convert.ToInt32(checkBoxAPrev.Checked), Convert.ToInt32(checkBoxVPrev.Checked));
        }

        private void checkBoxVPrev_CheckedChanged(object sender, EventArgs e)
        {
            if (m_objPreview != null)
                m_objPreview.PreviewEnable("", Convert.ToInt32(checkBoxAPrev.Checked), Convert.ToInt32(checkBoxVPrev.Checked));
        }

        private void comboBoxAudio_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                lock (m_objLock)
                {
                    m_objLive.DeviceSet(eMFDeviceType.eMFDT_Audio, comboBoxAudio.SelectedIndex, "");
                }
            }
            catch { }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            m_bWork = false;
            cancelSource.Cancel();
            m_threadWorker.Join(1000);

            lock (m_objLock)
            {
                m_objLive.DeviceClose();
            }
            m_objReader.ReaderClose();

            m_objMFSink.SinkClose();
        }

        private void checkBoxDelay_CheckedChanged(object sender, EventArgs e)
        {
            
        }

        private void trackBarTimeDelay_Scroll(object sender, EventArgs e)
        {
            //textBoxTimeDelay.Text = trackBarTimeDelay.Value.ToString();
            m_objDelay.PropsSet("mdelay.time", trackBarTimeDelay.Value.ToString());
            delayTime.ValueChanged -= delayTime_ValueChanged;
            delayTime.Value = trackBarTimeDelay.Value;
            delayTime.ValueChanged += delayTime_ValueChanged;
        }

        private void textBoxTimeDelay_TextChanged(object sender, EventArgs e)
        {
            //m_objDelay.PropsSet("mdelay.time", textBoxTimeDelay.Text);
        }

        private void Form1_SizeChanged(object sender, EventArgs e)
        {
            if (m_objPreview != null) m_objPreview.PreviewWindowSet("", panelPreview.Handle.ToInt32());
        }

        private void trackBarAlpha_Scroll(object sender, EventArgs e)
        {
            m_dblAlpha = (double)trackBarAlpha.Value / 100;
        }

        private void comboBoxAudioEx_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                lock (m_objLock)
                {
                    m_objLive.DeviceSet(eMFDeviceType.eMFDT_ExtAudio, comboBoxAudioEx.SelectedIndex, "");
                }
            }
            catch { }
        }

        private void buttonUpdateLineIn_Click(object sender, EventArgs e)
        {
            CheckLineIn();
        }

        private void checkBoxVirtDev_CheckedChanged(object sender, EventArgs e)
        {
            lock (this)
            {
                if (checkBoxVirtDev.Checked)
                {
                    m_objMFSink.SinkInit("MFLiveSink", "MFormats VSource", null);
                }
                else
                {
                    m_objMFSink.SinkClose();
                }
            }
        }

        private void comboBox_DropDown(object sender, EventArgs e)
        {
            ComboBox senderComboBox = (ComboBox)sender;
            int newWidth = senderComboBox.DropDownWidth;
            int width = senderComboBox.DropDownWidth;
            System.Drawing.Font font = senderComboBox.Font;
            System.Drawing.Graphics g = senderComboBox.CreateGraphics();
            int vertScrollBarWidth = (senderComboBox.Items.Count > senderComboBox.MaxDropDownItems) ?
              System.Windows.Forms.SystemInformation.VerticalScrollBarWidth : 0;
            foreach (object item in ((ComboBox)senderComboBox).Items)
            {
                string s = senderComboBox.GetItemText(item);
                newWidth = (int)g.MeasureString(s, font).Width + vertScrollBarWidth;
                if (width < newWidth)
                {
                    width = newWidth;
                }
            }
            senderComboBox.DropDownWidth = width;
        }
        private void button1_Click_1(object sender, EventArgs e)
        {
            IMFAsyncOperation operation;
            eMState state = eMState.eMS_Running;
            // as parameters, you can specify audio codec and its attributes
            m_objDelay.DelayExportBufferByTime(textBoxExportPath.Text, "codec='libmp3lame", -trackBarTimeDelay.Value, (int)delayExportDuration.Value, out operation);
            if (operation== null)
            {
                MessageBox.Show("An error in the DelayExportBufferByTime method occured!" + Environment.NewLine + "Please check that the export path is specified correctly" + Environment.NewLine
                    + "and that the delay position is not 0");
                return;
            }
            double dblProgress;
            while(state== eMState.eMS_Running)
            {
                operation.OperationGetState(out state, out dblProgress);
            }
            MessageBox.Show("Export completed - " + state.ToString());
        }

        private void delayTime_ValueChanged(object sender, EventArgs e)
        {
            trackBarTimeDelay.Value = (int)delayTime.Value;
            m_objDelay.PropsSet("mdelay.time", trackBarTimeDelay.Value.ToString());
        }

        private void button2_Click_1(object sender, EventArgs e)
        {
            SaveFileDialog sDialog = new SaveFileDialog();
            sDialog.Filter = "MP4 files (*.mp4)|*.mp4";
            if (sDialog.ShowDialog() == DialogResult.OK)
            {
                textBoxExportPath.Text = sDialog.FileName;
            }
        }
    }
}
